/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 支付宝(app支付、服务窗支付) request
 *
 * @author
 * @version FjnxAlipayJsapiPayReq.java, v 0.1 2024-11-26 14:52:13
 */
@Data
public class FjnxAlipayJsapiPayReq extends FjnxBizRequest implements Serializable {

    private static final long serialVersionUID = -2213838555962908974L;


    /**
     * 支付场景，WEB--网上商城, H5--页面收银台, APPLETS--商家小程序, OFFICIAL--商家公众号, POS--pos终端, APP--商户APP, OTHER--其他场景
     * (选填)
     */
    @Length(max = 8, message = "payScene长度不能超过8")
    private String payScene;

    /**
     * 内部用户号，用于内外部客户号绑定，也用于获取组合支付时核心客户号
     * (选填)
     */
    @Length(max = 25, message = "memberNo长度不能超过25")
    private String memberNo;

    /**
     * 外部客户号，用于内外部客户号绑定
     * (选填)
     */
    @Length(max = 15, message = "customNo长度不能超过15")
    private String customNo;

    /**
     * 交易金额，单位为元，精确到小数点后两位,带小数点
     * (选填)
     */
    @Length(max = 12, message = "txnAmt长度不能超过12")
    private String txnAmt;

    /**
     * 业务类型，默认主扫支付，SCAN--主扫支付, JSPAY--服务窗支付, APP--APP支付, H5--H5支付
     * (选填)
     */
    @Length(max = 16, message = "tradeType长度不能超过16")
    private String tradeType;

    /**
     * 商户订单信息描述
     * (选填)
     */
    @Length(max = 128, message = "merchantOrderInfo长度不能超过128")
    private String merchantOrderInfo;

    /**
     * 商户订单信息详情
     * (选填)
     */
    private List<FjnxMerchantOrderInfoDtlReq> merchantOrderInfoDtl;

    /**
     * 备注，在对账单展示
     * (选填)
     */
    @Length(max = 128, message = "attach长度不能超过128")
    private String attach;

    /**
     * 扫码支付授权码，设备读取用户展示的条码或者二维码信息
     * (选填)
     */
    @Length(max = 18, message = "userAhrCd长度不能超过18")
    private String userAhrCd;

    /**
     * 与buyerId不能同时为空，若是APP、H5支付可为空
     * (选填)
     */
    @Length(max = 100, message = "buyerLogonId长度不能超过100")
    private String buyerLogonId;

    /**
     * 与buyerLogonId不能同时为空，若是APP、H5支付可为空
     * (选填)
     */
    @Length(max = 28, message = "buyerId长度不能超过28")
    private String buyerId;

    /**
     * 订单生成时间
     * (选填)
     */
    @Length(max = 14, message = "timeStart长度不能超过14")
    private String timeStart;

    /**
     * 订单失效时间，不输入默认生成时间+5分钟
     * (选填)
     */
    @Length(max = 14, message = "timeExpire长度不能超过14")
    private String timeExpire;

    /**
     * 支付结果异步通知标识，Y--通知，N--不通知
     * (选填)
     */
    @Length(max = 1, message = "isNotifyFlg长度不能超过1")
    private String isNotifyFlg;

    /**
     * 支付结果异步通知标识为Y时必输
     * (选填)
     */
    @Length(max = 128, message = "notifyUrl长度不能超过128")
    private String notifyUrl;

    /**
     * H5支付需要上送
     * (选填)
     */
    @Length(max = 400, message = "quitUrl长度不能超过400")
    private String quitUrl;

    /**
     * 支付通道，默认线下支付，OFFLINE--线下通道，ONLINE--线上通道
     * (选填)
     */
    @Length(max = 16, message = "payChnl长度不能超过16")
    private String payChnl;

    /**
     * 终端发起交易需要上送
     * (选填)
     */
    private List<FjnxTermInfoReq> termInfo;

}