package com.fshows.apienum;

import com.fshows.request.*;
import com.fshows.response.*;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 福建农信相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum FjnxApiDefinitionEnum implements IApiDefinition {

    SCAN_ORDER_CREATE(
            "付款码支付下单",
            "/front/order/ScanPay",
            "1.0.0",
            "TRADE",
            FjnxScanOrderCreateReq.class,
            FjnxScanOrderCreateRes.class
    ),
    ALIPAY_JSAPI_PAY(
            "支付宝H5下单",
            "/front/order/AlPay",
            "1.0.0",
            "TRADE",
            FjnxAlipayJsapiPayReq.class,
            FjnxAlipayJsapiPayRes.class
    ),
    WX_JSAPI_PAY(
            "微信公众号下单",
            "/front/order/WxPay",
            "1.0.0",
            "TRADE",
            FjnxWxJsapiPayReq.class,
            FjnxWxJsapiPayRes.class
    ),
    UNION_JSAPI_PAY(
            "银联JS支付",
            "/front/order/UnJsPay",
            "1.0.0",
            "TRADE",
            FjnxUnionJsapiPayReq.class,
            FjnxUnionJsapiPayRes.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "/front/order/QueryOrder",
            "1.0.0",
            "TRADE",
            FjnxOrderQueryReq.class,
            FjnxOrderQueryRes.class
    ),
    REFUND_APPLY(
            "收银台退款接口",
            "/front/order/RefundOrder",
            "1.0.0",
            "TRADE",
            FjnxOrderRefundReq.class,
            FjnxOrderRefundRes.class
    ),
    UNION_USER_ID(
            "通过授权码获取用户开放标识",
            "/front/order/QueryUserIdentity",
            "1.0.0",
            "TRADE",
            FjnxUnionUserIdReq.class,
            FjnxUnionUserIdRes.class
    ),
    BILL_APPLY(
            "商户对账单申请",
            "/front/apply/MchtStatementApply",
            "1.0.0",
            "TRADE",
            FjnxBillApplyRequest.class,
            FjnxBillApplyResponse.class
    ),
    BILL_DOWNLOAD(
            "商户对账单下载",
            "/front/download/MchtRecordDown",
            "1.0.0",
            "TRADE",
            FjnxBillDownloadRequest.class,
            FjnxBaseResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * 接口类型：
     *  MERCHANT - 商户接口
     *  TRADE  -  交易接口
     *  COMMON  - 通用接口
     */
    private String interfaceType;


    FjnxApiDefinitionEnum(String name,
                          String apiSubURI,
                          String version,
                          String interfaceType,
                          Class requestClass,
                          Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}