/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version PersonBindRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class PersonBindRequest extends FbankRequest {
    /**
     * 业务订单号 (Y 32 发起请求时由调用端传递给企富通的唯一请求流水号)
     */
    @NotNull
    private String bizChannelOrderid;
    /**
     * 商户侧用户唯一ID (Y <=40 调用端传递给企富通的企业用户唯一 ID)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 手机号 (Y 11 用户接收短信验证信息的手机号码，必须在企富通存档存在)
     */
    @NotNull
    private String custMobile;
    /**
     * 个人用户姓名 (Y <=60 个人用户进行实名认证的姓名)
     */
    @NotNull
    private String custName;
    /**
     * 证件类型 (Y 2 证件类型: 0:二代身份证)
     */
    @NotNull
    private String custIdt;
    /**
     * 证件号码 (Y 18 个人用户进行实名认证的证件号（目前为二代身份证号码）)
     */
    @NotNull
    private String custIdNo;
    /**
     * 银行预留手机号 (Y 11 银行卡的预留手机号)
     */
    @NotNull
    private String mobilePhoneNum;
    /**
     * 卡号 (Y <=40 需要绑定的银行账号)
     */
    @NotNull
    private String acct;
    /**
     * 别名 (N <=100 用户自己定义的昵称，属于非必填项)
     */
    private String acctAlias;
    /**
     * 验证码 (N 6 测试环境是：000000，时效为10 分钟，有效期内只允许输错五次)
     */
    private String activeCode;
    /**
     * 验证码流水号 (N N/A 与短信验证码一一对应)
     */
    private String activeCodeSerialNo;

}