/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version MerchantDayBalanceQueryRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class MerchantDayBalanceQueryRequest extends FbankRequest {
    /**
     * 当前页 (Y 正整数)
     */
    @NotNull
    private String pageNo;
    /**
     * 每页显示记录数 (Y 正整数，每页最多显示 200条)
     */
    @NotNull
    private String pageSize;
    /**
     * 查询开始时间 (Y yyyy-MM-dd)
     */
    @NotNull
    private String startDate;
    /**
     * 查询结束时间 (Y yyyy-MM-dd（起止时间区间不超过 180 天）)
     */
    @NotNull
    private String endDate;

}