/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import com.fshows.fbank.sdk.request.item.Beneficiary;
import com.fshows.fbank.sdk.request.item.Shareholder;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author buhao
 * @version EnterpriseCertificateRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class EnterpriseCertificateRequest extends FbankRequest {
    /**
     * 调用方用户ID (Y <=40 调用方传递给企富通的用户 ID)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 企业名称 (Y <=50 该企业的工商注册名称（与注册工商信息时一致）)
     */
    @NotNull
    private String entName;
    /**
     * 证件类型 (Y 2 枚举值： 01：营业执照 02：统一社会信用代码 03：三证合一代码)
     */
    @NotNull
    private String enterpriseCardType;
    /**
     * 证件号码 (Y <=32 与企业证件类型对应的企业注册号（营业执照编号、统一社会信用代码、三证合一代码）)
     */
    @NotNull
    private String enterpriseRegistrationNo;
    /**
     * 法人名称 (Y <=20 用于实名认证企业的法人姓名（与注册工商信息时一致）)
     */
    @NotNull
    private String corporationName;
    /**
     * 法人证件号码 (Y 18 用于实名认证企业的法人身份证号码（与注册工商信息时一致）)
     */
    @NotNull
    private String corporationIdNo;
    /**
     * 法人证件签发日期yyyy-MM-dd (C datetime YYYY-MM-DD, 商户托底户为暂记户时必传)
     */
    private String corporationIdStartDate;
    /**
     * 法人证件到期日期yyyy-MM-dd (C datetime YYYY-MM-DD，如过是长期等，请转成“2999-12-31”, 商户托底户为暂记户时必传)
     */
    private String corporationIdEndDate;
    /**
     * 账户号 (Y 22 该企业用户在企富通开立的账户号)
     */
    @NotNull
    private String accountNo;
    /**
     * 绑定卡 (C <=40 企业用户绑定来款账户和结算账户（用作入金来款账户和结算账户），更新时不用传值)
     */
    private String acct;
    /**
     * 账户名 (C <=255 绑定对私卡时需跟企业法人同户名，更新时不用传值)
     */
    private String accountName;
    /**
     * 银行简称 (C <=10 绑定银行卡的所属银行简称。银行简称的值参见银行简称附录，更新时不用传值)
     */
    private String bankCode;
    /**
     * 账户类型 (C 1 枚举值： 1：对公 2：对私 更新时不用传值)
     */
    private String businessType;
    /**
     * 账户类型 (C 1 枚举值： 1：本行账户 2:他行账户 3：互金账户 更新时不用传值)
     */
    private String acctType;
    /**
     * 法人证件类型 (C 1 枚举值： 0：二代身份证（结算账户对私时必填）商户托底户为暂记户时必传)
     */
    private String corporationIdType;
    /**
     * 联行号 (N 13 结算账户所属行的联行号，更新时不用传值)
     */
    private String bankOrgNo;
    /**
     * 实资金卡号 (N <=40 入金绑卡的实资金账户，更新时不用传值)
     */
    private String realCapitalAcct;
    /**
     * 短信校验码 (C 6 测试环境是：123456，后管开通校验权限必填，更新时不用传值)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (C 19 短信验证码发送接口返回，后管开通权限后必填，更新时不用传值)
     */
    private String activeCodeSerialNo;
    /**
     * 经营地址 (C <=140 商户托底户为暂记户时必传)
     */
    private String businessLocation;
    /**
     * 法人联系电话 (C 11 商户托底户为暂记户且客户细类为个体经营时必传)
     */
    private String corporationPhone;
    /**
     * 客户细类 (C 3 参考附录四，取值只能为大类 200 中的值，商户托底户为暂记户时必传)
     */
    private String category;
    /**
     * 企业证件图片base64 (C 商户托底户为暂记户时必传，图片不超过 1.5M)
     */
    private String businessLicenseImage;
    /**
     * 企业证件图片后缀 (C 支持 jpg、jpeg、png、bmp 商户托底户为暂记户时必传)
     */
    private String businessLicenseImageSuffix;
    /**
     * 法人身份证正面base64 (C 商户托底户为暂记户时必传，图片不超过 1.5M)
     */
    private String corporationCardFrontImage;
    /**
     * 法人身份证正面后缀 (C 支持 jpg、jpeg、png、bmp 商户托底户为暂记户时必传)
     */
    private String corporationCardFrontImageSuffix;
    /**
     * 法人身份证反面base64 (C 商户托底户为暂记户时必传，图片不超过 1.5M)
     */
    private String corporationCardReverseImage;
    /**
     * 法人身份证反面后缀 (C 支持 jpg、jpeg、png、bmp 商户托底户为暂记户时必传)
     */
    private String corporationCardReverseImageSuffix;
    /**
     * 股东信息数组 (C Array 数组元素不超过 5 个, 商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private List<Shareholder> shareholderList;
    /**
     * 受益人信息数组 (C Array 数组元素不超过 5 个)
     */
    private List<Beneficiary> beneficiaryList;
    /**
     * 法人户籍地址 (C 255 客户细类为个体经营时必传)
     */
    private String corporationHomeAddr;
    /**
     * 法人职业代码 (C 1 客户细类为个体经营时必传 详见职业对照表)
     */
    private String corporationJob;
    /**
     * 法人常住地 (C 50 客户细类为个体经营时必传)
     */
    private String corporationPlace;
    /**
     * 企业联系电话 (C 20 商户托底户为暂记户时必传)
     */
    private String enterprisePhone;
    /**
     * 是否更新标识 (Y 1 1 新增 2 更新)
     */
    @NotNull
    private String sign;

}