/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.common;

import org.apache.commons.lang3.StringUtils;

/**
 * fbank api 枚举
 *
 * @author buhao
 * @version FBankApiEnum.java, v 0.1 2020-10-16 10:33 buhao
 */
public enum FBankApiEnum {
    /**
     * 账户查询
     */
    ACCOUNT_QUERY("账户查询",
            "com.fbank.open-api.api.v1.accountpayment.accountquery"),
    /**
     * 账户余额查询
     */
    QUERY_BALANCE("账户余额查询",
            "com.fbank.open-api.api.v1.accountBalanceQuery.queryBalance"),
    /**
     * 账户收支明细查询
     */
    BALANCE_CHANGE_RECORD_QUERY("账户收支明细查询",
            "com.fbank.open-api.api.v1.accountpayment.balanceChangeRecordQuery"),
    /**
     * 余账户额查询（待清分及账户余额）
     */
    QUERY_ACCOUNT_BAL("余账户额查询（待清分及账户余额）",
            "com.fbank.open-api.api.v1.account.queryAccountBal"),
    /**
     * 绑定卡解绑接口
     */
    UNBIND_CARD("绑定卡解绑接口",
            "com.fbank.open-api.api.v1.account.unbindCard"),
    /**
     * 账户绑卡信息查询
     */
    QUERY_ACCOUNT_BIND_ACCT("账户绑卡信息查询",
            "com.fbank.open-api.api.v1.account.queryAccountBindAcct"),
    /**
     * 商户日终余额查询
     */
    MERCHANT_DAY_BALANCE_QUERY("商户日终余额查询",
            "com.fbank.open-api.api.v1.account.merchantDayBalanceQuery"),
    /**
     * 个人实名开户（反洗钱）
     */
    NEW_PERSONAL_ACCOUNT("个人实名开户（反洗钱）",
            "com.fbank.open-api.api.v1.personalvirtualaccountopen.newPersonalAccount"),
    /**
     * 个人实名（反洗钱）
     */
    NEW_PERSONAL_REAL_NAME("个人实名（反洗钱）",
            "com.fbank.open-api.api.v1.certified.newPersonalRealName"),
    /**
     * 企业开户接口（反洗钱）
     */
    ENTERPRISE_ACCOUNT_REGISTER("企业开户接口（反洗钱）",
            "com.fbank.open-api.api.v2.accountpayment.enterpriseAccountRegister"),
    /**
     * 企业实名（反洗钱）
     */
    ENTERPRISE_CERTIFICATE("企业实名（反洗钱）",
            "com.fbank.open-api.api.v2.accountpayment.enterpriseCertificate"),
    /**
     * 账户昨日余额查询申请
     */
    QUERY_BALANCE_OF_YESTERDAY("账户昨日余额查询申请",
            "com.fbank.open-api.api.v1.account.queryBalanceOfYesterday"),
    /**
     * 账户资金冻结(V2)
     */
    CAPITAL_FROZEN("账户资金冻结(V2)",
            "com.fbank.open-api.api.v2.accountpayment.capitalFrozen"),
    /**
     * 账户资金解冻(V2)
     */
    CAPITAL_THAW("账户资金解冻(V2)",
            "com.fbank.open-api.api.v2.accountpayment.capitalThaw"),
    /**
     * 冻结解冻查询接口(V2)
     */
    QUERY_FROZEN_THAW("冻结解冻查询接口(V2)",
            "com.fbank.open-api.api.v2.accountpayment.queryFrozenThaw"),
    /**
     * 账户提现
     */
    VERIFY_WITHDRAWALS("账户提现",
            "com.fbank.open-api.api.v1.trade.verifyWithdrawals"),
    /**
     * 商户交易详情查询
     */
    TRANSACTION("商户交易详情查询",
            "com.fbank.open-api.trade.transaction"),
    /**
     * 账户消费分帐
     */
    CONSUME_LEDGER("账户消费分帐",
            "com.fbank.open-api.api.v1.consumptionfee.consumeLedger"),
    /**
     * 短信验证码发送
     */
    SEND_MSG_CODE("短信验证码发送",
            "com.fbank.open-api.api.v1.msgcode.sendmsgcode"),
    /**
     * 虚户动账通知查询
     */
    QUERY_VIRTUAL_NOTIFICATION("虚户动账通知查询",
            "com.fbank.open-api.api.v1.accounts.queryVirtualNotification"),
    /**
     * 虚拟账户绑卡接口-入账绑卡
     */
    DESPOSITBIND("虚拟账户绑卡接口-入账绑卡",
            "com.fbank.open-api.api.v1.card.enterprise.despositbind"),
    /**
     * 账户转账
     */
    VERIFYTRANSFER("账户转账", "com.fbank.open-api.api.v1.trade.verifyTransfer"),
    /**
     * 虚拟账户绑卡接口-企业结算绑卡
     */
    ENTERPRISE_BIND("虚拟账户绑卡接口-企业结算绑卡", "com.fbank.open-api.api.v1.card.enterprise.bind"),
    /**
     * 文件下载
     */
    FILE_DOWNLOAD("文件下载", "com.fbank.open-api.api.v1.fileDownload"),
    /**
     * 虚拟账户绑卡接口-个人会员绑卡
     */
    PERSON_BIND("虚拟账户绑卡接口-个人会员绑卡", "com.fbank.open-api.api.v1.card.bind");

    private String name;
    private String value;

    FBankApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static FBankApiEnum getByValue(String value) {
        FBankApiEnum[] valueList = FBankApiEnum.values();
        for (FBankApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}
