package com.fshows.com.fbank.openapi.sdk.crypto;

import com.fshows.com.fbank.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.fbank.openapi.sdk.util.AESUtils;

/**
 * AES-ECB加解密策略
 *
 * @author miwenming
 * @date 2020/5/21 11:23
 */
public class AESWithECBStrategy implements CryptoEncryptionService {
    @Override
    public String encrypt(String data, String key) throws Exception {
        return AESUtils.encryptWithECB(data, key);
    }

    @Override
    public String decrypt(String data, String key) throws Exception {
        return AESUtils.decryptWithECB(data, key);
    }

    @Override
    public String getAlgorithmType() {
        return AlgorithmTypeEnum.AES_ECB.getAlgorithmType();
    }
}
