package com.fshows.com.fbank.openapi.sdk.constant;

/**
 * 请求常量类
 *
 * @author miwenming
 * @date 2020/5/19 15:53
 */
public class RequestConstants {

    /**
     * 请求头
     */
    public class RequestHeader {
        /**
         * 算法服务标识-KEY
         */
        public static final String KEY_ALGORITHM = "algorithm";

        /** 服务唯一标识 */
        public static final String KEY_API_NAME = "api_name";

        /** 子服务编号 */
        public static final String KEY_API_CODE = "api_code";

        /** 服务模块编号 */
        public static final String KEY_MODULE_CODE = "module_code";

        /** 服务版本 */
        public static final String KEY_API_VERSION = "api_version";

        /** 请求流水号 */
        public static final String KEY_CLIENT_SERIAL_NO = "client_serial_no";
    }

    /**
     * 请求体
     */
    public class RequestBody {
        /** 签名数据 */
        public static final String KEY_SIGN_DATA = "signData";

        /** 待加密或已加密业务数据 */
        public static final String KEY_DATA = "data";

        /** 经过RSA加密后的AES加密随机密钥 */
        public static final String KEY_RANDOM_KEY_ENCRYPT = "randomKeyEncrypt";

        /** 请求时间戳 */
        public static final String KEY_TIMESTAMP = "timestamp";

        /** 商户号 */
        public static final String KEY_MERCHANT_NO = "merchantNo";

        /** 渠道号 */
        public static final String KEY_CHANNEL_NO = "channelNo";

        /** 签名类型 */
        public static final String KEY_SIGN_TYPE = "signType";

        /** 加密类型 */
        public static final String KEY_ENCRYPT_TYPE = "encryptType";

        /** SDK版本 */
        public static final String KEY_SDK_VERSION = "sdkVersion";

        /** 产品编号 */
        public static final String KEY_APP_ID = "appId";

        /** 应用编号 */
        public static final String KEY_SITE_ID = "siteId";

        /** H5请求时当前操作用户唯一编号 */
        public static final String KEY_USER_ID = "userId";
    }

    /**
     * 请求业务参数
     */
    public class RequestData {
        /** 文件下载业务参数 */
        public static final String BIZ_DATA = "bizData";
    }

    /**
     * 算法服务实现
     */
    public class AlgorithmService {
        /**
         * 服务算法标识-VALUE，rsaDetached表示双证书且安全加固
         **/
        public static final String ALGORITHM_TYPE_RSA_DETACHED = "rsaDetached";

        /**
         * 服务算法标识-VALUE，rsaService表示双证书
         **/
        public static final String ALGORITHM_TYPE_RSA = "rsaService";

        /**
         * 服务算法标识-VALUE，fileDownload表示文件下载
         **/
        public static final String ALGORITHM_TYPE_RSA_FILE = "fileDownload";
    }

    /**
     * SDK信息常量
     */
    public class SDK {
        public static final String VERSION = "2.4.4";
    }

}
