/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body.item;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version BalanceRecord.java, v 0.1 2020-10-19 11:01 buhao
 */
@Data
public class BalanceRecord {
    /**
     * 账户号 (用户在企富通开立的账户号)
     */
    @NotBlank
    private String accountNo;
    /**
     * 交易时间 (HH：MM：ss)
     */
    @NotBlank
    private String tradeDate;
    /**
     * 账务流水号 ()
     */
    @NotBlank
    private String tradeFlowNo;
    /**
     * 账务处理时间 (HH：MM：ss)
     */
    @NotBlank
    private String accountsDealDate;
    /**
     * 交易订单号 ()
     */
    @NotBlank
    private String flowNo;
    /**
     * 交易金额 (动账金额)
     */
    @NotBlank
    private String amount;
    /**
     * 交易后余额 (该账户本次动账后的余额)
     */
    @NotBlank
    private String balance;
    /**
     * 资金流向 (枚举值： 1:进帐 2:出账)
     */
    @NotBlank
    private String direction;
    /**
     * 账务处理类型 (枚举值： 1：内部户处理 2：其他账户处理（余额户为其他账户）)
     */
    @NotBlank
    private String accountsDealType;
    /**
     * 处理状态 (枚举值： 00：成功 01：失败)
     */
    @NotBlank
    private String handStatus;
    /**
     * 订单创建时间 (HH:MM:ss)
     */
    @NotBlank
    private String createDate;
    /**
     * 服务编码 (枚举值： 101001 : 充值 101002 : 转账 101003 : 提现 101004 : 提现回调 101007 : 虚户下账 101101 : 通用上账 101102 : 通用下账 200001 : 冻结充值 700001 : 商户清分 700002 : 商户结算 700003 : 调账 700005 : 收单记账 700006 : 资金划付 700008 : 收单补账 700009 : 本行代扣 800001 : 消费 800002 : 退款 800003 : 冲正 800004 : 消费撤销 800005：富民托底户下帐 800006：代付至虚户 101005 : 商户手续费收取 102002 : 结算交易 102001 : 清分交易)
     */
    @NotBlank
    private String serviceCode;
    /**
     * 交易类型 (枚举值： 1：充值 2：提现 3：转账 5：提现回调成功 6：提现回调失败 25：消费 26：消费撤销 27：退款 29：冲正 30：企业绑定账户入金 31：企业非绑定账户入金 32：内部户充值 33：内部户转余额户 34：余额户转内部户 35：内部户提现 36：内部户提现成功 37：内部户提现失败 38：消费手续费收益 39：商户结算上帐 40:提现手续费收益 41:二类户冻结充值 46：手续费消费分账分润 51：虚账代付 57：提现退汇 76：担保发薪汇总划付 77：担保发薪汇总划付退汇)
     */
    @NotBlank
    private String tradeType;
    /**
     * 入账方账户 (收款方账户)
     */
    private String accountIn;
    /**
     * 入账方账户名 ()
     */
    private String accountInName;
    /**
     * 出账方账户 (出账方账户)
     */
    private String accountOut;
    /**
     * 出账方账户名 ()
     */
    private String accountOutName;
    /**
     * 备注 (交易备注)
     */
    private String memo;
    /**
     * 扩展参数 (预留参数，如需使用需要和企富通服务方沟通。)
     */
    private String extend;
    /**
     * 对手账号 (对手账号)
     */
    private String othBaseAcctNo;
    /**
     * 对手名称 (对手名称)
     */
    private String othAcctDesc;
    /**
     * 对手行号 (对手行号)
     */
    private String othBankCode;
    /**
     * 对手行名 (对手行名)
     */
    private String othBankName;
}