/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import lombok.Data;

/**
 * @author buhao
 * @version QueryBalanceResponseBody.java, v 0.1 2020-10-19 09:59 buhao
 */
@Data
public class QueryBalanceResponseBody extends FbankResponseBody {
    /**
     * 账户号 Y 22 该用户在企富通开立的账户号
     */
    private String baseAcctNo;
    /**
     * 客户号 Y 16 该用户在企富通注册的会员号
     */
    private String clientNo;
    /**
     * 冻结金额 Y 20
     * 查询的账户已冻结的金额（账户
     * 总额-可用金额）
     */
    private String fundsHeld;
    /**
     * 账户总额 Y 20
     * 查询的账户的账户总额（冻结金
     * 额+可用余额）
     */
    private String ledgerBal;
    /**
     * 可用余额 Y 20
     * 查询的账户可使用的余额（账户
     * 总额-冻结金额）
     */
    private String availableBal;
}