/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import com.fshows.fbank.sdk.response.body.item.DepositAcct;
import com.fshows.fbank.sdk.response.body.item.PaymentConfirmationAcct;
import com.fshows.fbank.sdk.response.body.item.SettlementAcct;
import lombok.Data;

import java.util.List;

/**
 * @author buhao
 * @version QueryAccountBindAcctResponseBody.java, v 0.1 2020-10-16 11:42 buhao
 */
@Data
public class QueryAccountBindAcctResponseBody extends FbankResponseBody {
    /**
     * 企富通账户号 (Y 22 企富通为用户开立的账户号)
     */
    private String accountNo;
    /**
     * 二级账户号 (N 32 二级账户号)
     */
    private String accountCoreNo;
    /**
     * 企富通账户名 (Y 30)
     */
    private String accountName;
    /**
     * 结算卡的列表 (N)
     */
    private List<SettlementAcct> settlementAcctList;
    /**
     * 入金卡的列表 (N 入参企富通账号为空时，查询该会员所有账户绑定入金卡)
     */
    private List<DepositAcct> depositAcctList;
    /**
     * 打款认证卡的列表 (N)
     */
    private List<PaymentConfirmationAcct> paymentConfirmationAcctList;

}