/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import com.fshows.fbank.sdk.response.body.item.Balance;
import lombok.Data;

import java.util.List;

/**
 * @author buhao
 * @version MerchantDayBalanceQueryResponseBody.java, v 0.1 2020-10-16 11:42 buhao
 */
@Data
public class MerchantDayBalanceQueryResponseBody extends FbankResponseBody {
    /**
     * 每页记录数 (Y 每页显示记录数)
     */
    private String pageSize;
    /**
     * 总记录数 (Y 当前账户的所有动账记录总数)
     */
    private String totalSize;
    /**
     * 当前页数 (Y 传入的当前页数)
     */
    private String pageNo;
    /**
     * 结果集合名字 (Y 注意：下面的参数都是集合里面对象的属性)
     */
    private List<Balance> balanceList;

}