/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version EnterpriseAccountRegisterResponseBody.java, v 0.1 2020-10-16 17:54 buhao
 */
@Data
public class EnterpriseAccountRegisterResponseBody extends FbankResponseBody {
    /**
     * 会员号 (企业用户在企富通注册的会员号)
     */
    @NotBlank
    private String custNo;
    /**
     * 商户侧用户唯一ID (调用方传递给企富通的用户ID)
     */
    @NotBlank
    private String custMerchantNo;
    /**
     * 企富通账户号 (企富通账户号，开通打款认证权限，打款申请发起成功后不会返回)
     */
    private String balanceAccNo;
    /**
     * 打款认证流水号 (发起打款认证生成的交易流水号（商户开通打款认证权限后调用该接口才会生成，用来进行打款确认。）)
     */
    private String requestNo;
    /**
     * 二级账户号 (二级账户号)
     */
    @NotBlank
    private String accountCoreNo;
    /**
     * 入金账户名 (入金账户名)
     */
    @NotBlank
    private String depositAccountName;
}