/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request.item;

import lombok.Data;

/**
 * @author buhao
 * @version Beneficiary.java, v 0.1 2020-10-16 17:47 buhao
 */
@Data
public class Beneficiary {
    /**
     * 受益人证件类型 (0-二代身份证 商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private String beneficiaryCardType;
    /**
     * 受益人证件号码 (商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private String beneficiaryCardNo;
    /**
     * 受益人证件发证日期yyyy-MM-dd (商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private String beneficiaryCardStartDate;
    /**
     * 受益人证件到期日期yyyy-MM-dd (长期则传2999-12-31,商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private String beneficiaryCardEndDate;
    /**
     * 受益人联系电话 (商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private String beneficiaryPhone;
    /**
     * 受益人地址 (商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private String beneficiaryLocation;
    /**
     * 受益人姓名 (商户托底户为暂记户时必传，客户细类为个体经营时可不传)
     */
    private String beneficiaryName;
}