/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version VerifyTransferRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class VerifyTransferRequest extends FbankRequest {
    /**
     * 调用方用户ID (Y <=40 调用方传递给企富通的用户 ID)
     */
    @NotBlank
    private String custMerchantNo;
    /**
     * 出账方姓名 (Y 32)
     */
    @NotBlank
    private String nameOut;
    /**
     * 出账方账号 (Y 22 用户在企富通开立的账户号)
     */
    @NotBlank
    private String accountOut;
    /**
     * 调用方用户ID（入账方） (Y 32 商户传递给企富通的用户 ID)
     */
    @NotBlank
    private String custNoIn;
    /**
     * 入账方姓名 (Y 32)
     */
    @NotBlank
    private String nameIn;
    /**
     * 入账方账号 (Y 22 用户在企富通开立的账户号)
     */
    @NotBlank
    private String accountIn;
    /**
     * 币种 (Y 3 CNY：人民币)
     */
    @NotBlank
    private String currency;
    /**
     * 交易金额 (Y <=15 单位是元，保留两位小数0.00)
     */
    @NotBlank
    private String tradeAmount;
    /**
     * 商户订单号 (Y 32 用户发起请求时由商户传递给企富通的唯一请求流水号，如响应失败，请重新生成。)
     */
    @NotBlank
    private String bizChannelOrderid;
    /**
     * 短信验证码 (N 6 测试环境是：000000，失效为 10 分钟，有效期内最多只允许错五次)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (N N/A 调用 8.1 短信验证码发送返回的短信验证码流水号)
     */
    private String activeCodeSerialNo;
    /**
     * 对公/对私标识 (N 1 枚举值： 1:对私 2:对公)
     */
    private String acctFlag;
    /**
     * 交易备注 (N <=50 交易备注)
     */
    private String tradeRemark;

}