/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version SendmsgcodeRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class SendmsgcodeRequest extends FbankRequest {
    /**
     * 调用方用户ID (C <=40 调用方传递给企富通的用户 ID，验证码类型为 12、13、15、17、18、19、24 时必传，根据该参数取注册手机号)
     */
    private String custMerchantNo;
    /**
     * 用户手机号 (C 11 验证码类型为 00、01、02、03、04、05、20、21、22 必传；其余类型不传，否则验证不通过)
     */
    private String custMobile;
    /**
     * 验证码类型 (Y 2 00-非实名注册 01-个人注册、 02-个人实名 03-企业注册 04-企业实名 05-小微企业实名 12-提现 13-转账 15-消费分账 17-消费手续费 18-个人实名(仅实名) 19-企业实名(仅实名) 20-虚户个人绑卡 21-虚户企业结算绑卡 22-虚户企业入金绑卡 24-代付转账)
     */
    @NotBlank
    private String operateType;
    /**
     * 交易订单号 (C 32 当 operate_type 为 12、13、15、17、24 时上送进行校验)
     */
    private String bizChannelOrderid;
    /**
     * 交易金额 (C <=15 当 operate_type 为 12、13、15、17、24 时上送进行校验)
     */
    private String tradeAmount;

}