/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version QueryVirtualNotificationRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class QueryVirtualNotificationRequest extends FbankRequest {
    /**
     * 商户侧用户唯一ID (Y <=40 调用端传递给企富通的企业用户唯一 ID)
     */
    @NotBlank
    private String custMerchantNo;
    /**
     * 商户账号 (Y <=32 企业或者个人用户在企富通开立的账户号)
     */
    @NotBlank
    private String accountNo;
    /**
     * 查询起始日期 (Y 8 格式：yyyyMMdd)
     */
    @NotBlank
    private String beginDate;
    /**
     * 查询终止日期 (Y 8 格式：yyyyMMdd)
     */
    @NotBlank
    private String endDate;

}