/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version QueryBalanceRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class QueryBalanceRequest extends FbankRequest {
    /**
     * 调用方用户ID (调用方传递给企富通的用户 ID)
     */
    @NotBlank
    private String custMerchantNo;
    /**
     * 企富通账户号 (用户在企富通开立的账户账号)
     */
    @NotBlank
    private String baseAcctNo;
    /**
     * 会员类型 (枚举值： 00：个人 08：企业)
     */
    private String custType;
}