/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version EnterpriseBindRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class EnterpriseBindRequest extends FbankRequest {
    /**
     * 业务订单号 (Y 32 发起请求时由调用端传递给企富通的唯一请求流水号)
     */
    @NotBlank
    private String bizChannelOrderid;
    /**
     * 商户侧用户唯一ID (Y <=40 调用端传递给企富通的企业用户唯一 ID)
     */
    @NotBlank
    private String custMerchantNo;
    /**
     * 户名 (Y <=255 需要绑定的结算卡在银行开卡时的户名)
     */
    @NotBlank
    private String cardName;
    /**
     * 手机号码 (Y 11 用于接收短信验证码信息的手机号，必须在企富通存档存在)
     */
    @NotBlank
    private String custMobile;
    /**
     * 卡标签 (Y 30 卡标签为： 02:结算账户)
     */
    @NotBlank
    private String tag;
    /**
     * 卡号 (Y <=40 需要绑定为结算卡的卡号)
     */
    @NotBlank
    private String acct;
    /**
     * 账户类型 (Y 1 账户类型有三个选项可输入枚举： 1:本行账户 2:他行账户 3:互金账户)
     */
    @NotBlank
    private String acctType;
    /**
     * 银行简称 (Y <=10 需要绑定的结算卡的开卡行的银行简称，例： 工商银行的银行简称：ICBC)
     */
    @NotBlank
    private String bankCode;
    /**
     * 业务类型 (Y 1 该结算卡将来对应的业务类型枚举： 1：对公 2：对私)
     */
    @NotBlank
    private String businessType;
    /**
     * 法人证件类型 (N 1 业务类型为对私时属于必输项)
     */
    private String corporationIdType;
    /**
     * 法人证件号码 (N 18 业务类型为对私时属于必输项)
     */
    private String corporationIdNo;
    /**
     * 法人手机号码 (Y 11 业务类型为对私时属于必输项)
     */
    @NotBlank
    private String corporationPhone;
    /**
     * 联行号 (N 13 结算卡的开卡银行的联行号)
     */
    private String bankOrgNo;
    /**
     * 短信验证码 (N 6 测试环境是：000000，时效为 10 分钟，有效期内只允许输错五次)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (N N/A 与短信验证码一一对应)
     */
    private String activeCodeSerialNo;

}