/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version ConsumeLedgerRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class ConsumeLedgerRequest extends FbankRequest {
    /**
     * 交易订单号 (Y 32 用户发起请求时由商户传递给企富通的唯一请求流水号，如响应失败，请重新生成。)
     */
    @NotBlank
    private String bizChannelOrderid;
    /**
     * 币种 (Y 3 CNY | 人民币，目前主要支持 CNY)
     */
    @NotBlank
    private String currency;
    /**
     * 交易金额 (Y <=15 单位是元，保留两位小数 0.00)
     */
    @NotBlank
    private String tradeAmount;
    /**
     * 手续费金额 (Y <=15 单位是元，保留两位小数 0.00（大于等于 0 且小于交易金额）)
     */
    @NotBlank
    private String poundageAmount;
    /**
     * 出账方商户侧id (Y <=40 商户传递给企富通的用户 ID)
     */
    @NotBlank
    private String custMerchantOut;
    /**
     * 出账账户 (Y 32 不能和分账信息中的 account_in(入账账户)相同)
     */
    @NotBlank
    private String accountOut;
    /**
     * 出账账户名 (N 32)
     */
    private String nameOut;
    /**
     * 交易性质 (Y 2 交易性质： 01|正常交易 02|冲正交易 03|撤销交易 04|退款交易 05|补单交易 06|平账交易)
     */
    @NotBlank
    private String transNature;
    /**
     * 分账信息 (Y json 数组字符串，存在多个分账方则传入多个 json 字符串，详见接口说明)
     */
    @NotBlank
    private String ledgerAccountInfo;
    /**
     * 分润信息 (N json 数组字符串，存在多个分账方则传入多个 json 字符串，详见接口说明)
     */
    private String feeSplittingInfo;
    /**
     * 出账方会员类型 (N 2 枚举类型： 00：个人 08：企业)
     */
    private String custTypeOut;
    /**
     * 备注 (N <=50 用于描述交易或者情况说明，无特殊含义，不使用该字段时传空字符串，暂不支持传空)
     */
    private String remark;
    /**
     * 担保标志 (N 选填枚举： true-担保 false-非担保 不填默认 false)
     */
    private String guarantee;
    /**
     * 短信校验码 (C 6 测试环境是：000000，后管开通校验权限必填)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (C 19 短信验证码发送接口返回，后管开通权限后必填)
     */
    private String activeCodeSerialNo;

}