/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version CapitalFrozenRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class CapitalFrozenRequest extends FbankRequest {
    /**
     * 调用方用户ID (Y <=40 调用方传递给企富通的用户 ID)
     */
    @NotBlank
    private String custMerchantNo;
    /**
     * 业务订单号 (Y <=30 用户发起请求时由商户传递给企富通的唯一请求流水号)
     */
    @NotBlank
    private String bizChannelOrderid;
    /**
     * 账户号 (Y 22 企富通开立的账户号)
     */
    @NotBlank
    private String accountNo;
    /**
     * 冻结金额 (Y <=15 单位是元，保留两位小数 0.00)
     */
    @NotBlank
    private String amount;
    /**
     * 币种 (Y <=10 默认为CNY，目前仅支持CNY)
     */
    @NotBlank
    private String currency;
    /**
     * 冻结原因 (N <=200 冻结原因)
     */
    private String frozenReason;

}