/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version BalanceChangeRecordQueryRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class BalanceChangeRecordQueryRequest extends FbankRequest {
    /**
     * 调用方用户ID (调用方传递给企富通的用户 ID)
     */
    @NotBlank
    private String custMerchantNo;
    /**
     * 当前页 ()
     */
    @NotBlank
    private String pageNo;
    /**
     * 每页显示记录数 (20条)
     */
    @NotBlank
    private String pageSize;
    /**
     * 企富通账户号 (用户在企富通开立的账户号)
     */
    @NotBlank
    private String accountNo;
    /**
     * 交易查询开始时间 ()
     */
    @NotBlank
    private String tradeStartDate;
    /**
     * 交易查询结束时间 ()
     */
    @NotBlank
    private String tradeEndDate;

}