/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version AccountQueryRequest.java, v 0.1 2020-10-16 11:41 buhao
 */
@Data
public class AccountQueryRequest extends FbankRequest {
    /**
     * 调用方用户 ID
     */
    @NotBlank
    @Length(max = 40)
    private String custMerchantNo;
    /**
     * 会员类型
     */
    @NotBlank
    @Length(max = 2, min = 2)
    private String custType;
}