package com.fshows.com.fbank.openapi.sdk.crypto;

import com.fshows.com.fbank.openapi.sdk.util.CertFileUtils;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;

/**
 * RSA加解密抽象服务
 *
 * @author miwenming
 * @date 2020/5/21 15:41
 */
public abstract class RSACryptoEncryptionService implements CryptoEncryptionService {
    @Override
    public String encrypt(String data, String key) throws Exception {
        PublicKey publicKey = CertFileUtils.toPublicKey(key);
        Cipher cipher = Cipher.getInstance(CertFileUtils.ALGORITHM_RSA);
        cipher.init(Cipher.ENCRYPT_MODE, publicKey);
        return Base64.encodeBase64String(cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String decrypt(String data, String key) throws Exception {
        Cipher cipher = Cipher.getInstance(CertFileUtils.ALGORITHM_RSA);
        cipher.init(Cipher.DECRYPT_MODE, CertFileUtils.toPrivateKey(key));
        return new String(cipher.doFinal(Base64.decodeBase64(data)), StandardCharsets.UTF_8);
    }
}
