package com.fshows.com.fbank.openapi.sdk.constant;

import com.fshows.com.fbank.openapi.sdk.crypto.CryptoSignatureService;
import com.fshows.com.fbank.openapi.sdk.crypto.RSACryptoWithHardwareStrategy;
import com.fshows.com.fbank.openapi.sdk.crypto.RSACryptoWithSoftwareStrategy;

/**
 * 签名服务枚举
 *
 * @author miwenming
 * @date 2020/5/21 20:37
 */
public enum CryptoSignatureServiceEnum {
    /**
     * 软件签名服务
     */
    RSA_SOFTWARE(RSACryptoWithSoftwareStrategy.class),

    /** 硬件签名服务 */
    RSA_HARDWARE(RSACryptoWithHardwareStrategy.class);

    private Class<? extends CryptoSignatureService> clazz;

    CryptoSignatureServiceEnum(Class<? extends CryptoSignatureService> clazz) {
        this.clazz = clazz;
    }

    public Class<? extends CryptoSignatureService> getClazz() {
        return clazz;
    }
}
