package com.fshows.com.fbank.openapi.sdk.config;

import com.fshows.com.fbank.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.fbank.openapi.sdk.util.CertFileUtils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * 抽象参数配置
 *
 * @author tangjunmao
 * @date 2018/10/18
 */
public abstract class Configuration {

    private static final int TIMEOUT_DEFAULT = 300_000;

    /**
     * 富民银行接口调用地址，默认生产环境
     *
     * 沙箱环境：https://opensandbox.fbank.com
     * 生产环境：https://open.fbank.com
     */
    public abstract String remoteAddress();

    /**
     * 建立连接的超时时间，单位：毫秒
     */
    public int connectionTimeout() {
        return TIMEOUT_DEFAULT;
    }

    /**
     * 建立连接后，读取返回数据的超时时间，单位：毫秒
     */
    public int readTimeout() {
        return TIMEOUT_DEFAULT;
    }

    /**
     * 字符集， 默认UTF-8
     */
    public Charset charset() {
        return StandardCharsets.UTF_8;
    }

    /**
     * 签名、验签算法类型，默认为硬件签名
     */
    public String signType() {
        return AlgorithmTypeEnum.RSA_SOFTWARE.getAlgorithmType();
    }

    /**
     * 加解密算法类型，默认AES-CBC
     */
    public String encryptType() {
        return AlgorithmTypeEnum.AES_ECB.getAlgorithmType();
    }

    /**
     * 富民开放平台RSA公钥 用于对上送的randomKey加密
     */
    public abstract String fbankEncPubKey();

    /**
     * 富民开放平台RSA公钥 用于返回数据验签
     */
    public String fbankSignPubKey() {
        return fbankEncPubKey();
    }

    /**
     * 商户的RSA私钥 用于上送的签名及返回randomKeyEncrypt的解密
     */
    public String privateKey() {
        return CertFileUtils.getPrivateKeyFromPfxFile(pfxFileName(), pfxPassword());
    }

    /**
     * 商户私钥文件名 默认沙箱
     */
    public String pfxFileName() {
        // return "CFCA_Test.pfx";
        return "Merchant_Private_CFCA_sandbox.pfx";
    }

    /**
     * 商户私钥文件密码
     */
    public String pfxPassword() {
        // return "FMopenplatform";
        return "11111111";
    }

    /**
     * 商户号
     */
    public abstract String merchantNo();

    /**
     * 渠道号 默认为空
     */
    public String channelNo() {
        return "";
    }

    /**
     * 富民产品编号
     */
    public abstract String appId();

    /**
     * 商户应用编号
     */
    public abstract String siteId();
}
