package com.fshows.com.fbank.openapi.sdk.client;

import com.fshows.com.fbank.openapi.sdk.config.ModuleCode;

import java.io.Serializable;

/**
 * 请求业务接口的配置
 *
 * @author tyh
 * @date 2018/11/1
 */
public class OpenContext implements Serializable {

    private static final long serialVersionUID = 1L;

    // 用于标识请求方法
    private String apiName;
    // 用于标识请求接口
    private String apiCode;
    // 用于标识请求模块
    private String moduleCode;

    public OpenContext(String apiName, String apiCode, String moduleCode) {
        this.apiName = apiName;
        this.apiCode = apiCode;
        this.moduleCode = moduleCode;
    }

    /**
     * 获取initialToken的请求
     *
     * @return OpenContext
     */
    public static OpenContext initialTokenContext() {
        // 获取initialToken使用的apiName
        final String initialTokenApiName = "com.fbank.openapi.auth.initialToken";
        return new OpenContext(initialTokenApiName, "initialToken", ModuleCode.AUTH_SERVER.rawValue());
    }

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiCode() {
        return apiCode;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getModuleCode() {
        return moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }
}
