/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.ParamQueryResponse;
import lombok.Data;


/**
 * @author zhubo
 * @version MerchatnAuditQueryRequest.java, v 0.1 2023-11-04 14:42 zhubo
 */
@Data
public class ParamQueryRequest extends EasyPayMerchantBaseRequest<ParamQueryResponse> {
    private static final long serialVersionUID = 7135489647895917056L;

    /**
     * 商户唯一标识
     */
    private String paraType;

    /**
     * 原操作流水号，最长20字符
     */

    private String paraName;

    /**
     * 消息类型
     */
    private String messageType = "QUERYPARA";

    @Override
    public Class<ParamQueryResponse> getResponseClass() {
        return ParamQueryResponse.class;
    }
}
