/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade.jsapi;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.base.SignFiled;
import com.fshows.easypay.sdk.enums.EasyPayApiEnum;
import com.fshows.easypay.sdk.request.base.EasyPayAppendReqDataBaseRequest;
import com.fshows.easypay.sdk.request.trade.EasyPayTradeDataBaseRequest;
import com.fshows.easypay.sdk.request.trade.TradeAppendReqData;
import com.fshows.easypay.sdk.response.trade.jspai.JsapiDataResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhaoxumin
 * @version JsapiDataRequest.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class JsapiDataRequest extends EasyPayTradeDataBaseRequest<JsapiDataResponse, EasyPayApiEnum> {

    private static final long serialVersionUID = -3921036162579962276L;
    /**
     * 附加请求数据-仅正向交易需要
     */
    @SignFiled(needJoin = false)
    private TradeAppendReqData appendData;

    /**
     * 支付成功后的结果通知地址
     */
    @NotBlank
    @JSONField(name = "org_back_url")
    private String orgBackUrl;

    /**
     * 前台通知地址-云闪付-支付成功后的页面跳转地址
     */
    @JSONField(name = "org_front_url")
    private String orgFrontUrl;

    /**
     * 按类型取值为：用户唯一标识。微信：支付的appId(wxSubAppid)下的openId，参考文档，字段名：openid；
     * 支付宝：支付宝用户唯一标识 buyer_user_id，参考文档，字段名：user_id；
     * 银联：传 银联JS-获取用户标识 返回的 payerId
     */
    @NotBlank
    @JSONField(name = "payer_id")
    private String payerId;

    /**
     * WAJS1:支付宝-生活号支付;
     * WAJS2:支付宝-小程序支付;
     * WTJS1:微信-公众号支付;
     * WTJS2:微信-小程序支付;
     * WUJS1:银联二维码-JS支付
     */
    @NotBlank
    @JSONField(name = "trade_code")
    private String tradeCode;

    /**
     * 金额,单位分；取值范围：1-10000000000,示例值(1)
     */
    @NotNull
    @JSONField(name = "trade_amt")
    private Long tradeAmt;

    /**
     * 订单支付超时时间；长度：8。单位：秒, 不填默认为300（5分钟)这个值会传给对应的支付渠道，但是条码本身有限制支付有时间，一般为1分钟。
     */
    @JSONField(name = "timeout_minutes")
    private Integer timeoutMinutes;

    /**
     * 订单标题，最长128字符
     */
    @NotBlank
    @JSONField(name = "order_info")
    private String orderInfo;

    /**
     * 订单描述
     */
    @JSONField(name = "info_attach")
    private String infoAttach;

    /**
     * 清算标识；取值-含义：{“0”:”D0清算（前提：开通秒到功能）”,”1”:默认结算方式（T1orD1）”,”2”:”自主结算”}
     */
    @JSONField(name = "patner_settle_flag")
    private String patnerSettleFlag;

    /**
     * 清算-分账标识；取值-含义：分账标识第一优先，{“0”:”标准不分账（默认）”,”1”:”分账”}
     */
    @JSONField(name = "split_settle_flag")
    private String splitSettleFlag;

    /**
     * 优惠出资方编号；长度：32
     */
    private String investor;

    /**
     * 下游优惠金额
     */
    @JSONField(name = "org_preferential_amt")
    private String orgPreferentialAmt;

    /**
     * wx:支付使用的appid
     */
    @JSONField(name = "wx_sub_appid")
    private String wxSubAppid;

    /**
     * 下游外部订单号/缴费号；仅涉及“合规改造的四方平台”适用；长度：50
     */
    private String attach;

    /**
     * 下游手续费；仅涉及“合规改造的四方平台”适用；长度：12
     */
    @JSONField(name = "handing_fee")
    private String handingFee;

    /**
     * 下游机构商户唯一标识，仅涉及“合规改造的四方平台”适用
     */
    @JSONField(name = "org_smercode")
    private String orgSmercode;

    /**
     * 小商户终端号
     */
    @JSONField(name = "org_sterminalcode")
    private String orgSterminalcode;

    /**
     * 特殊计费；仅涉及“合规改造的四方平台”适用；长度：121
     */
    private String otherfee;

    @Override
    public EasyPayAppendReqDataBaseRequest getAppendData() {
        return appendData;
    }
}