/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.rate;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhubo
 * @version UnionRate.java, v 0.1 2023-11-08 15:40 zhubo
 */
@Data
public class UnionRate implements Serializable {
    private static final long serialVersionUID = 5865031750459314396L;

    /**
     * 微信：功能ID：2
     * 支付宝：功能ID:3
     * 银联二维码:功能ID：12
     * 银联营销业务:功能ID：14
     */
    private Integer funcId;

    /**
     * 借记卡扣率方式 :1-封顶;0-不封顶
     */
    @JSONField(name = "DStlmType")
    @Length(max = 1, message = "DStlmType借记卡扣率方式长度不能超过1")
    private String DStlmType;
    /**
     * 借记卡扣率（单位：%）
     */
    @JSONField(name = "DCalcVal")
    @Length(max = 12, message = "DCalcVal借记卡扣率长度不能超过12")
    private String DCalcVal;
    /**
     * 借记卡封顶金额（单位：元）,借记卡扣率方式封顶时必填
     */
    @JSONField(name = "DStlmMaxAmt")
    @Length(max = 8, message = "DStlmMaxAmt借记卡封顶金额长度不能超过8")
    private String DStlmMaxAmt;
    /**
     * 借记卡手续费最低值（单位：元）
     */
    @JSONField(name = "DFeeLowLimit")
    @Length(max = 8, message = "DFeeLowLimit差值下限长度不能超过8")
    private String DFeeLowLimit;
    /**
     * 信用卡扣率（单位：%）
     */
    @JSONField(name = "CCalcVal")
    @Length(max = 12, message = "CCalcVal信用卡扣率长度不能超过12")
    private String CCalcVal;
    /**
     * 信用卡手续费最低值（单位：元）
     */
    @JSONField(name = "CFeeLowLimit")
    @Length(max = 8, message = "CFeeLowLimit信用卡手续费最低值长度不能超过8")
    private String CFeeLowLimit;

    /**
     * 开通状态：0-未开通；1-已开通；X-失败；3-处理中；9-商户已注销
     */
    @Length(max = 1, message = "state开通状态长度不能超过1")
    private String state;
    /**
     * 错误描述
     */
    @Length(max = 200, message = "retMsg错误描述长度不能超过200")
    private String retMsg;
}
