/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.client.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.easypay.sdk.client.EasyPayUploadClient;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.merchant.UploadPicRequest;
import com.fshows.easypay.sdk.response.merchant.UploadPicResponse;
import com.fshows.easypay.sdk.util.SignUtil;
import com.fshows.easypay.sdk.util.ValidateUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPayUploadClientImpl
implements EasyPayUploadClient {
    private static final Logger log = LoggerFactory.getLogger(EasyPayUploadClientImpl.class);
    private final String orgId;
    private final String signType;
    protected String postUrl;
    private String fubeiPrivateKey;

    public EasyPayUploadClientImpl(String postUrl, String orgId, String signType, String fubeiPrivateKey) {
        this.postUrl = postUrl;
        this.orgId = orgId;
        this.signType = signType;
        this.fubeiPrivateKey = fubeiPrivateKey;
    }

    @Override
    public UploadPicResponse upload(UploadPicRequest request) throws EasyPayException {
        return this.upload(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPicResponse upload(UploadPicRequest request, String subAgentId) throws EasyPayException {
        String responseString;
        block15: {
            ValidateUtil.validateWithThrow(request, new Class[0]);
            File file = request.getFileName();
            CloseableHttpClient httpclient = HttpClients.createDefault();
            responseString = "";
            long startTime = System.currentTimeMillis();
            try {
                HttpPost httpPost = new HttpPost(this.postUrl);
                MultipartEntityBuilder entity = MultipartEntityBuilder.create();
                Map<String, String> parameters = this.getRequestParameters(request, subAgentId);
                for (String key : parameters.keySet()) {
                    entity.addTextBody(key, parameters.get(key), ContentType.DEFAULT_TEXT);
                }
                entity.addPart("fileName", (ContentBody)new FileBody(file));
                httpPost.setEntity(entity.build());
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(3000).build();
                httpPost.setConfig(requestConfig);
                log.info("\u3010easypay-sdk\u3011\u8bf7\u6c42\u63a5\u53e3\u5f00\u59cb >> \u56fe\u7247\u4e0a\u4f20\u5f00\u59cb >> url={}, param={}, request={} ", new Object[]{this.postUrl, parameters, httpPost.getRequestLine()});
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() != 200) break block15;
                HttpEntity httpEntity = response.getEntity();
                log.info("record bad-liquidation info >> result=success >> payCompany=easypay-sdk >> class={} >> url={}, request={}, response={}, cost={}", new Object[]{this.getClass().getSimpleName(), this.postUrl, request, httpEntity, System.currentTimeMillis() - startTime});
                log.info("\u3010easypay-sdk\u3011\u8bf7\u6c42\u63a5\u53e3\u7ed3\u675f >> \u56fe\u7247\u4e0a\u4f20\u51fa\u53c2 >> response = " + response.getStatusLine());
                try {
                    if (httpEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)httpEntity);
                        log.info("\u3010easypay-sdk\u3011\u56fe\u7247\u4e0a\u4f20\u51fa\u53c2 >> response content:" + responseString);
                        EntityUtils.consume((HttpEntity)httpEntity);
                    }
                }
                finally {
                    response.close();
                }
            }
            catch (Exception e) {
                log.error("record bad-liquidation info >> result=fail >> payCompany=easypay-sdk >> class={} >> url={}, request={},ex={},cost={}", new Object[]{this.getClass().getSimpleName(), this.postUrl, request, ExceptionUtils.getStackTrace((Throwable)e), System.currentTimeMillis() - startTime});
                log.error("\u3010easypay-sdk\u3011\u8bf7\u6c42\u5f02\u5e38 >> \u56fe\u7247\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
                throw new EasyPayException("\u6613\u751f\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
            }
            finally {
                if (httpclient != null) {
                    try {
                        httpclient.close();
                    }
                    catch (IOException e) {
                        log.warn("\u8d44\u6e90\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }
        }
        return StrUtil.isBlank((CharSequence)responseString) ? null : (UploadPicResponse)JSONObject.parseObject((String)responseString, UploadPicResponse.class);
    }

    private <R> Map<String, String> getRequestParameters(UploadPicRequest request, String appId) throws Exception {
        TreeMap<String, String> parameterMap = SignUtil.getParameterMap(request);
        parameterMap.put("clientCode", StrUtil.blankToDefault((CharSequence)appId, (String)this.orgId));
        parameterMap.put("version", "1.0");
        parameterMap.remove("fileName");
        String sign = SignUtil.generateMd5Sign(parameterMap, this.fubeiPrivateKey);
        parameterMap.put("MAC", sign);
        return parameterMap;
    }
}

