/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.request.trade.scanpay.ScanPayDataRequest;
import com.fshows.easypay.sdk.response.trade.scanpay.ScanPayDataResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhaoxumin
 * @version PayBaseRequest.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class PayBaseRequest extends EasyPayBizRequest<ScanPayDataResponse> {

    private static final long serialVersionUID = -7600454573210414087L;
    /**
     * 机构号
     */
    @NotBlank
    @JSONField(name = "org_id")
    private String orgId;

    /**
     * 商户号
     */
    @NotBlank
    @JSONField(name = "org_mercode")
    private String orgMercode;

    /**
     * 终端号
     */
    @NotBlank
    @JSONField(name = "org_termno")
    private String orgTermno;

    /**
     * 产品码(不超过5位)
     */
    @JSONField(name = "prod_code")
    private String prodCode;

    /**
     * 交易流水，35位不定长，规则：orgId 前四位+后四位+yyyyMMddhhmmss+6位自定义 合计35位长度（唯一）
     */
    @NotBlank
    @JSONField(name = "org_trace")
    private String orgTrace;

    /**
     * 签名
     */
    @NotBlank
    private String sign;

    /**
     * 签名方式
     */
    @NotBlank
    @JSONField(name = "sign_type")
    private String signType;

    /**
     * 产品流水
     */
    @JSONField(name = "prod_trace")
    private String prodTrace;

    /**
     * 业务请求数据，签名数据
     */
    @NotNull
    @JSONField(name = "data")
    private ScanPayDataRequest data;

    /**
     * 请求方自定义信息
     */
    @JSONField(name = "org_info")
    private String orgInfo;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<ScanPayDataResponse> getResponseClass() {
        return ScanPayDataResponse.class;
    }
}