/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.Serializable;

/**
 * @author zhubo
 * @version UploadPicRequest.java, v 0.1 2023-11-04 15:29 zhubo
 */
@Data
public class UploadPicRequest implements Serializable {
    private static final long serialVersionUID = 8636236610595215348L;
    /**
     * 文件名称
     */
    @NotNull(message = "fileName文件不能为空")
    private File fileName;

    /**
     * 图片模式
     */
    @NotBlank(message = "picMode图片模式不能为空")
    private String picMode;
}
