/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.client.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.easypay.sdk.client.EasyPayRefundClient;
import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.enums.EasyPayApiEnum;
import com.fshows.easypay.sdk.enums.SignTypeEnum;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.base.EasyPayRefundBizResponse;
import com.fshows.easypay.sdk.util.FsHttpUtil;
import com.fshows.easypay.sdk.util.LogUtil;
import com.fshows.easypay.sdk.util.SignUtil;
import com.fshows.easypay.sdk.util.ValidateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPayRefundClientImpl
implements EasyPayRefundClient {
    private static final Logger log = LoggerFactory.getLogger(EasyPayRefundClientImpl.class);
    @NotBlank
    protected String apiParentUrl;
    @NotBlank
    private final String orgId;
    @NotBlank
    private final String signType;
    @NotBlank
    private String fubeiPrivateKey;
    @NotBlank
    private String easyPayPublicKey;
    protected int connectionTimeout = 5000;
    protected int readTimeout = 20000;
    private static final SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public EasyPayRefundClientImpl(String apiParentUrl, String orgId, String signType, String fubeiPrivateKey, String easyPayPublicKey) {
        this.apiParentUrl = apiParentUrl;
        this.orgId = orgId;
        this.signType = signType;
        this.fubeiPrivateKey = fubeiPrivateKey;
        this.easyPayPublicKey = easyPayPublicKey;
    }

    @Override
    public <R, T> EasyPayRefundBizResponse<T> execute(EasyPayBizRequest<R> request, EasyPayApiDefinition easyPayApiDefinition, String url) throws EasyPayException {
        return this.execute(request, easyPayApiDefinition, url, null);
    }

    @Override
    public <R, T> EasyPayRefundBizResponse<T> execute(EasyPayBizRequest<R> request, EasyPayApiDefinition definition, String postUrl, String subAppId) throws EasyPayException {
        String method = definition.getMethod();
        this.validateParam(request, method);
        long startTime = System.currentTimeMillis();
        String url = this.apiParentUrl + method;
        try {
            Map<String, Object> requestData = this.getRequestData(request, subAppId);
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={},request={}", (Object)url, requestData);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Accept-Encoding", "identity");
            String fsHttpResult = FsHttpUtil.postString(url, JSONObject.toJSONString(requestData), "utf-8", "application/json;charset=utf-8", this.connectionTimeout, this.readTimeout, headers);
            log.info("record bad-liquidation info >> result=success >> payCompany=easypay-sdk >> class={} >> url={}, request={}, response={}, cost={}", new Object[]{this.getClass().getSimpleName(), url, request, fsHttpResult, System.currentTimeMillis() - startTime});
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},request={},response={},cost={}", new Object[]{url, requestData, fsHttpResult, System.currentTimeMillis() - startTime});
            return this.parseResponse(fsHttpResult, request);
        }
        catch (Exception ex) {
            log.error("record bad-liquidation info >> result=fail >> payCompany=easypay-sdk >> class={} >> url={}, request={},ex={},cost={}", new Object[]{this.getClass().getSimpleName(), url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            log.error("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},request={},ex={},cost={}", new Object[]{url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new EasyPayException(ex.getMessage());
        }
    }

    private boolean checkSign(String fsHttpResult) {
        JSONObject resMap = JSONObject.parseObject((String)fsHttpResult);
        if ("000000".equals(resMap.getString("sysRetcode")) || "000000".equals(resMap.getString("sysRetCode"))) {
            String sign = resMap.getString("sign");
            if (StringUtils.isEmpty((CharSequence)sign)) {
                return false;
            }
            return CollUtil.isNotEmpty((Map)resMap.getJSONObject("bizData")) && SignUtil.verifySign((Map)resMap.get((Object)"bizData"), this.signType, resMap.get((Object)"sign").toString(), this.easyPayPublicKey);
        }
        return true;
    }

    private <R, T> EasyPayRefundBizResponse<T> parseResponse(String result, EasyPayBizRequest<R> request) throws Exception {
        if (!this.checkSign(result)) {
            LogUtil.error(log, "\u3010easypay-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> fsHttpResult={}", result);
            throw new EasyPayException("[easypay-sdk]\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
        }
        EasyPayRefundBizResponse bizResponse = (EasyPayRefundBizResponse)JSON.parseObject((String)result, EasyPayRefundBizResponse.class);
        bizResponse.setBizData(JSON.parseObject((String)JSON.toJSONString(bizResponse.getBizData()), request.getResponseClass()));
        return bizResponse;
    }

    private <R> Map<String, Object> getRequestData(EasyPayBizRequest request, String appId) throws Exception {
        TreeMap<String, Object> requestDataMap = new TreeMap<String, Object>();
        TreeMap<String, String> signParameterMap = SignUtil.getSignParameterMap(request);
        String sign = SignUtil.generateSign(signParameterMap, SignTypeEnum.getByValue(this.signType).getAlgorithm(), this.fubeiPrivateKey);
        TreeMap<String, String> parameterMap = SignUtil.getNoSignParameterMap(request);
        requestDataMap.putAll(parameterMap);
        requestDataMap.put("orgId", StringUtils.defaultIfBlank((CharSequence)appId, (CharSequence)this.orgId));
        requestDataMap.put("signType", this.signType);
        requestDataMap.put("sign", sign);
        requestDataMap.put("bizData", signParameterMap);
        return requestDataMap;
    }

    private <R> void validateParam(EasyPayBizRequest request, String method) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.fubeiPrivateKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.easyPayPublicKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.signType)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == EasyPayApiEnum.getByValue(method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    static {
        EasyPayRefundClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

