/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade.scanpay;

import lombok.Data;

import java.io.Serializable;

/**
 * acqaddndata整体Json示例：{"orderInfo":{"title":"日用品","dctAmount":"10000","addnInfo":"屈臣氏(人民广场)店"},"goodsInfo":[{"id":"1234567890","name":"商品1","price":"500","quantity":"1"},{"id":"1234567891","name":"商品2","price":"1000","quantity":"2","category":"类目1","addnInfo":"商品图片http://www.95516.com/xxx.jpg"}],"customData":"this is customdata filled by acqCode"}
 *
 * @author zhaoxumin
 * @version QrAcqAddnData.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class QrAcqAddnData implements Serializable {


    private static final long serialVersionUID = -3245938542122727840L;
    /**
     * 订单信息. title必填
     */
    private String orderInfo;

    /**
     * 商品信息. id、name、price、quantity必填
     */
    private String goodsInfo;

    /**
     * 自定义数据
     */
    private String customData;
}