/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.easypay.sdk.client.EasyPayMerchantClient;
import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.enums.EasyMerchantApiEnum;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.base.EasyPayMerchantBizResponse;
import com.fshows.easypay.sdk.util.FsHttpUtil;
import com.fshows.easypay.sdk.util.SignUtil;
import com.fshows.easypay.sdk.util.ValidateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPayMerchantClientImpl
implements EasyPayMerchantClient {
    private static final Logger log = LoggerFactory.getLogger(EasyPayMerchantClientImpl.class);
    private final String appId;
    private final String url;
    private final String signType;
    private final String key;
    protected int connectionTimeout = 5000;
    protected int readTimeout = 20000;
    private static final SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public EasyPayMerchantClientImpl(String appId, String signType, String url, String key) {
        this.appId = appId;
        this.signType = signType;
        this.url = url;
        this.key = key;
    }

    @Override
    public <R extends EasyPayMerchantBizResponse, T> EasyPayMerchantBizResponse<R> execute(EasyPayMerchantBaseRequest<R> request, EasyPayApiDefinition easyPayApiDefinition) throws EasyPayException {
        return this.execute(request, easyPayApiDefinition, this.appId);
    }

    @Override
    public <R extends EasyPayMerchantBizResponse, T> EasyPayMerchantBizResponse<R> execute(EasyPayMerchantBaseRequest<R> request, EasyPayApiDefinition definition, String subAppId) throws EasyPayException {
        String method = definition.getMethod();
        this.validateParam(request, method);
        long startTime = System.currentTimeMillis();
        String url = this.url + method;
        try {
            this.buildEasyPayBizRequest(request, (String)StringUtils.defaultIfBlank((CharSequence)subAppId, (CharSequence)this.appId));
            Map<String, String> requestData = this.getRequestData(request, (String)StringUtils.defaultIfBlank((CharSequence)subAppId, (CharSequence)this.appId));
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={}, request={}, requestData={}", new Object[]{url, JSON.toJSONString(request), requestData});
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            String easyPayResponse = FsHttpUtil.post(url, requestData, "utf-8", "application/x-www-form-urlencoded", this.connectionTimeout, this.readTimeout, headers);
            log.info("record bad-liquidation info >> result=success >> payCompany=easypay-sdk >> class={} >> url={}, request={}, response={}, cost={}", new Object[]{this.getClass(), url, request, easyPayResponse, System.currentTimeMillis() - startTime});
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={}, request={}, requestData={}, response={}, cost={}", new Object[]{url, JSON.toJSONString(request), requestData, easyPayResponse, System.currentTimeMillis() - startTime});
            return this.parseResponse(easyPayResponse, request);
        }
        catch (Exception ex) {
            log.error("record bad-liquidation info >> result=fail >> payCompany=easypay-sdk >> class={} >> url={}, request={},ex={},cost={}", new Object[]{this.getClass(), url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            log.error("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={}, request={},ex={},cost={}", new Object[]{url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new EasyPayException(ex.getMessage());
        }
    }

    private <R extends EasyPayMerchantBizResponse> void buildEasyPayBizRequest(EasyPayMerchantBaseRequest<R> request, String appId) {
        request.setClientCode(appId);
        request.setVersion("1.0");
    }

    private <R extends EasyPayMerchantBizResponse, T> EasyPayMerchantBizResponse<R> parseResponse(String result, EasyPayMerchantBaseRequest<R> request) {
        EasyPayMerchantBizResponse bizResponse = (EasyPayMerchantBizResponse)JSON.parseObject((String)result, EasyPayMerchantBizResponse.class);
        bizResponse.setData(JSON.parseObject((String)result, request.getResponseClass()));
        return bizResponse;
    }

    private <R extends EasyPayMerchantBizResponse> Map<String, String> getRequestData(EasyPayMerchantBaseRequest<R> request, String appId) throws EasyPayException {
        TreeMap<String, String> parameterMap = SignUtil.getMerchantSignParameterMap(request);
        parameterMap.put("clientCode", appId);
        parameterMap.put("version", "1.0");
        String sign = SignUtil.generateMd5Sign(parameterMap, this.key);
        request.setMAC(sign);
        parameterMap.put("MAC", sign);
        return parameterMap;
    }

    private <R extends EasyPayMerchantBizResponse> void validateParam(EasyPayMerchantBaseRequest<R> request, String method) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.key)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.signType)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == EasyMerchantApiEnum.getByValue(method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    static {
        EasyPayMerchantClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

