/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant;

import com.fshows.easypay.sdk.response.base.EasyPayMerchantBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhubo
 * @version EasyPayMerchantAuditQueryResponse.java, v 0.1 2023-11-04 14:42 zhubo
 */
@Data
public class MerchantAuditQueryResponse extends EasyPayMerchantBizResponse implements Serializable {
    private static final long serialVersionUID = 4290646973159786108L;

    /**
     * 商户唯一标识
     */
    private String merTrace;

    /**
     * 原操作流水号，最长20字符
     */
    private String operaTrace;

    /**
     * 原报文类型
     */
    private String recentMessType;

    /**
     * 审核状态:9-待处理；3-待审核；0-审核通过；X-审核失败；1-审核驳回；5-待签约
     */
    private String auditStatus;

    /**
     * 审核说明
     */
    private String auditMsg;

    private String sysInfo;

    /**
     * 终端信息
     */
    private String funcInfo;

    /**
     * 进件审核人
     */
    private String staffId;

    /**
     * 电子协议编号
     */
    private String contractNo;

    /**
     * 营销报名id
     */
    private String rebateRecid;

    /**
     * 实际生效时间
     */
    private String actEffDate;
}
