/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version WxPromotionDetail.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class WxPromotionDetail implements Serializable {

    private static final long serialVersionUID = 669530423849265178L;
    /**
     * 券 ID
     */
    @JSONField(name = "promotion_id")
    private String promotionId;

    /**
     * 优惠名称
     */
    private String name;

    /**
     * 优惠范围
     */
    private String scope;

    /**
     * 优惠类型
     */
    private String type;

    /**
     * 优惠券面额
     */
    private int amount;

    /**
     * 活动 ID
     */
    @JSONField(name = "activity_id")
    private String activityId;

    /**
     * 微信出资
     */
    @JSONField(name = "wxpay_contribute")
    private int wxpayContribute;

    /**
     * 商户出资
     */
    @JSONField(name = "merchant_contribute")
    private int merchantContribute;

    /**
     * 其他出资
     */
    @JSONField(name = "other_contribute")
    private int otherContribute;

    /**
     * 优惠币种
     */
    private String currency;

    /**
     * 单品列表
     */
    @JSONField(name = "goods_detail")
    private GoodsDetail goodsDetail;
}