/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade.scanqrcode;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.base.SignFiled;
import com.fshows.easypay.sdk.enums.EasyPayApiEnum;
import com.fshows.easypay.sdk.request.base.EasyPayAppendReqDataBaseRequest;
import com.fshows.easypay.sdk.request.trade.EasyPayTradeDataBaseRequest;
import com.fshows.easypay.sdk.request.trade.TradeAppendReqData;
import com.fshows.easypay.sdk.response.scanqrcode.ScanQrcodeDataResponse;
import lombok.Data;

/**
 * @author zhaoxumin
 * @version ScanQrcodeDataRequest.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class ScanQrcodeDataRequest extends EasyPayTradeDataBaseRequest<ScanQrcodeDataResponse, EasyPayApiEnum> {

    private static final long serialVersionUID = -6535575207284575439L;
    /**
     * 附加请求数据-仅正向交易需要
     */
    @SignFiled(needJoin = false)
    private TradeAppendReqData appendData;

    /**
     * 支付成功后的结果通知地址
     */
    @JSONField(name = "org_back_url")
    private String orgBackUrl;

    /**
     * 交易码，WAC2B:支付宝-主扫支付，WUC2B:银联二维码-主扫支付
     */
    @JSONField(name = "trade_code")
    private String tradeCode;

    /**
     * 金额，单位分；取值范围：1-10000000000
     */
    @JSONField(name = "trade_amt")
    private Long tradeAmt;

    /**
     * 订单支付超时时间；长度：8。单位：秒, 不填默认为300（5分钟)
     * 这个值会传给对应的支付渠道，但是条码本身有限制支付有时间，一般为1分钟
     */
    @JSONField(name = "timeout_minutes")
    private Integer timeoutMinutes;

    /**
     * 订单标题 [1,128]
     */
    @JSONField(name = "order_info")
    private String orderInfo;

    /**
     * 订单描述
     */
    @JSONField(name = "info_attach")
    private String infoAttach;

    /**
     * 清算-延迟结算标识；取值-含义：{"0":标准不延迟（默认””,”1”:”延迟结算）”}
     */
    @JSONField(name = "delay_settle_flag")
    private String delaySettleFlag;

    /**
     * 清算-秒到标识；取值-含义：{"0":”D0清算（前提：开通秒到功能）”,"1":”T1清算（默认）”,"2":”自主结算”}
     */
    @JSONField(name = "patner_settle_flag")
    private String patnerSettleFlag;

    /**
     * 清算-分账标识；取值-含义：{"0":”标准不分账（默认）”,"1":”分账”}
     */
    @JSONField(name = "split_settle_flag")
    private String splitSettleFlag;

    /**
     * 优惠出资方编号；长度：32
     */
    private String investor;

    /**
     * 下游优惠金额
     */
    @JSONField(name = "org_preferential_amt")
    private String orgPreferentialAmt;

    /**
     * wx:支付使用的appid
     */
    @JSONField(name = "wx_sub_appid")
    private String wxSubAppid;

    /**
     * 下游外部订单号/缴费号；仅涉及“合规改造的四方平台”适用；长度：50
     */
    private String attach;

    /**
     * 下游手续费；仅涉及“合规改造的四方平台”适用；长度：12
     */
    @JSONField(name = "handing_fee")
    private String handingFee;

    /**
     * 下游机构商户唯一标识，仅涉及“合规改造的四方平台”适用
     */
    @JSONField(name = "org_smercode")
    private String orgSmercode;

    /**
     * 小商户终端号
     */
    @JSONField(name = "org_sterminalcode")
    private String orgSterminalcode;

    /**
     * 特殊计费；仅涉及“合规改造的四方平台”适用；长度：121
     */
    private String otherfee;

    @Override
    public EasyPayAppendReqDataBaseRequest getAppendData() {
        return appendData;
    }
}