/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.order;

import com.fshows.easypay.sdk.base.SignFiled;
import com.fshows.easypay.sdk.enums.EasyPayApiEnum;
import com.fshows.easypay.sdk.request.trade.EasyPayQsTradeDataBaseRequest;
import com.fshows.easypay.sdk.response.order.EasyPayOrderQsQueryResponse;
import lombok.Data;

/**
 * @author zhangmj
 * @version EasyPayOrderQueryRequest.java, v 0.1 2023-10-31 09:35 zhangmj
 */
@Data
public class EasyPayOrderQsQueryRequest extends EasyPayQsTradeDataBaseRequest<EasyPayOrderQsQueryResponse, EasyPayApiEnum> {

    private static final long serialVersionUID = -2451352044817367075L;

    @SignFiled(needJoin = false)
    private OrderAppendReqData appendData;

    /**
     * 终端号
     */
    private String termNo;

    /**
     * 原outTrace
     */
    private String orderNo;

    /**
     * 终端商户号
     */
    private String termMercode;

    /**
     * 原交易业务日期，格式:yyyyMMdd
     */
    private String tradeDate;

    /**
     * 原交易业务日期不能为空
     */
    private String oriOrgTrace;


    private String version = "1.0";
}