/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.client;

import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.merchant.UploadPicRequest;
import com.fshows.easypay.sdk.response.merchant.UploadPicResponse;

/**
 * @author zhubo
 * @version EasyPayUploadClient.java, v 0.1 2023-11-04 20:45 zhubo
 */
public interface EasyPayUploadClient {

    /**
     * 上传
     *
     * @param request 请求
     * @return {@link UploadPicResponse}
     */
    UploadPicResponse upload(UploadPicRequest request) throws EasyPayException;

    /**
     * 上传
     *
     * @param request    请求
     * @param subAgentId 子代理id
     * @return {@link UploadPicResponse}
     * @throws EasyPayException 轻松支付例外
     */
    UploadPicResponse upload(UploadPicRequest request, String subAgentId) throws EasyPayException;
}
