/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.easypay.sdk.client.impl;

import com.fshows.easypay.sdk.request.base.EasyPayDataBaseRequest;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;

/**
 * 易生API接口定义
 *
 * @author zhaoxumin
 * @version EasyPayApiDefinition.java, v 0.1 2023-10-27 13:39
 */
public interface EasyPayApiDefinition {

    /**
     * 请求方法名
     *
     * @return
     */
    String getMethod();

    /**
     * 获取api请求参数类型
     *
     * @return
     */
    <T extends EasyPayDataBaseRequest> Class<T> getRequestClass();

    /**
     * 获取api响应参数类型
     *
     * @return
     */
    <T extends EasyPayDataBaseResponse> Class<T> getResponseClass();
}