/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.easypay.sdk.client;

import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.base.EasyPayDataBaseRequest;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;

/**
 * @author zhaoxumin
 * @version EasyPayBaseClient.java, v 0.1 2023-10-27 13:32
 */
public interface EasyPayBaseClient {

    /**
     * 请求易生接口
     *
     * @param request
     * @param tradeApiDefinitionEnum
     * @return
     * @param <T>
     * @param <R>
     * @throws EasyPayException
     */
    <T extends EasyPayDataBaseResponse, R extends EasyPayApiDefinition> T execute(EasyPayDataBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws EasyPayException;

    /**
     * 请求易生接口（子服务商）
     *
     * @param request
     * @param tradeApiDefinitionEnum
     * @param subAppId
     * @return
     * @param <R>
     * @throws EasyPayException
     */
    <T extends EasyPayDataBaseResponse, R extends EasyPayApiDefinition> T execute(EasyPayDataBaseRequest<T, R> request, R tradeApiDefinitionEnum, String subAppId) throws EasyPayException;

}
