/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhaoxumin
 * @version WxDetail.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class WxDetail implements Serializable {

    private static final long serialVersionUID = -1883904865956088024L;
    /**
     * 订单原价
     */
    @JSONField(name = "cost_price")
    private Integer costPrice;

    /**
     * 单品列表
     */
    @JSONField(name = "goods_detail")
    private List<WxGoodsDetail> goodsDetail;

    /**
     * 商家小票
     */
    @JSONField(name = "receipt_id")
    private String receiptId;

    /**
     * wx:订单优惠标记，代金券或立减优惠功能的参数
     */
    @JSONField(name = "wx_goods_tag")
    private String wxGoodsTag;
}