/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.WechatJsApiConfigResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version WechatJsApiConfigRequest.java, v 0.1 2023-11-04 15:14 zhubo
 */
@Data
public class WechatJsApiConfigRequest extends EasyPayMerchantBaseRequest<WechatJsApiConfigResponse> {
    private static final long serialVersionUID = -7738160820032720783L;

    /**
     * 微信号
     */
    @NotBlank
    private String wechatId;

    /**
     * 授目录
     */
    @NotBlank
    private String jsAPIPath;

    /**
     * 报文类型
     */
    private String messageType = "ALTERJSAPIPATH";

    @Override
    public Class<WechatJsApiConfigResponse> getResponseClass() {
        return WechatJsApiConfigResponse.class;
    }
}
