/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.base;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangmj
 * @version EasyPayOrderRefundResponse.java, v 0.1 2023-10-30 16:55 zhangmj
 */
@Data
public class EasyPayRefundBizResponse<T> implements Serializable {
    private static final long serialVersionUID = 8403975557413376496L;

    /**
     * 客户编号
     */
    private String orgId;

    /**
     * 交易商户号
     */
    private String orgMerCode;

    /**
     * 交易终端号
     */
    private String orgTermNo;

    /**
     * 下游机构商户唯一标识
     */
    private String orgSmercode;

    /**
     * 产品流水
     */
    private String prodTrace;

    /**
     * 交易流水号
     * 35位不定长，建议按照如下规则：orgId 前四位+后四位+yyyyMMddhhmmss+自定义 （需要保证唯一）
     */
    private String orgTrace;

    /**
     * 业务产品码 实时退款 MCTKS
     */
    private String prodCode;

    /**
     * 签名 根据指定的签名方法计算出来的签名
     */
    private String sign;

    /**
     * 见签名方式，仅支持RSA。
     */
    private String signType;

    /**
     * GPS坐标系（WGS84、GCJ02、BD09）
     */
    private String orgGpstype;

    /**
     * 经度
     */
    private String orgLongitude;

    /**
     * 维度
     */
    private String orgLatitude;

    /**
     * 基站信息
     */
    private String orgBasestation;

    /**
     * 交易设备ip
     */
    private String orgDeviceIp;

    /**
     * 请求方自定义信息
     * JSON格式，原样返回
     */
    private String orgInfo;

    /**
     * 系统应答
     */
    private String sysRetCode;

    /**
     * 系统应答描述
     */
    private String sysRetMsg;

    /**
     * 业务数据
     */
    private T bizData;
}