/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.refund;

import com.fshows.easypay.sdk.base.SignFiled;
import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.refund.EasyPayOrderRefundBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangmj
 * @version EasyPayOrderRefundRequest.java, v 0.1 2023-10-30 16:54 zhangmj
 */
@Data
public class EasyPayOrderRefundBizRequest extends EasyPayBizRequest<EasyPayOrderRefundBizResponse> {

    private static final long serialVersionUID = 8374836959972018953L;

    /**
     * 交易商户号(必填)
     */
    @NotBlank
    @SignFiled(needJoin = false)
    private String orgMerCode;

    /**
     * 交易终端号(必填)
     */
    @NotBlank
    @SignFiled(needJoin = false)
    private String orgTermNo;

    /**
     * 下游机构商户唯一标识(选填)
     */
    @SignFiled(needJoin = false)
    private String orgSmercode;

    /**
     * 交易流水号
     * 35位不定长，建议按照如下规则：orgId 前四位+后四位+yyyyMMddhhmmss+自定义 （需要保证唯一）
     */
    @NotBlank
    @SignFiled(needJoin = false)
    private String orgTrace;

    /**
     * 业务产品码 实时退款 MCTKS
     */
    @SignFiled(needJoin = false)
    private String prodCode;

    /**
     * GPS坐标系（WGS84、GCJ02、BD09）
     */
    @SignFiled(needJoin = false)
    private String orgGpstype;

    /**
     * 经度
     */
    @SignFiled(needJoin = false)
    private String orgLongitude;

    /**
     * 维度
     */
    @SignFiled(needJoin = false)
    private String orgLatitude;

    /**
     * 基站信息
     */
    @SignFiled(needJoin = false)
    private String orgBasestation;

    /**
     * 交易设备ip
     */
    @SignFiled(needJoin = false)
    private String orgDeviceIp;

    /**
     * 请求方自定义信息
     */
    @SignFiled(needJoin = false)
    private String orgInfo;

    /**
     * 原商户订单号
     */
    @NotBlank
    @SignFiled(needJoin = true)
    private String oriOrgTrace;

    /**
     * 原机构订单号
     */
    @SignFiled(needJoin = true)
    private String oriOutTrace;

    /**
     * 原交易日期
     */
    @SignFiled(needJoin = true)
    private String oriBizDate;

    /**
     * 退货金额 单位：分
     */
    @NotBlank
    @SignFiled(needJoin = true)
    private String transAmt;

    @Override
    public Class<EasyPayOrderRefundBizResponse> getResponseClass() {
        return EasyPayOrderRefundBizResponse.class;
    }

}