/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version AliTradeFundBillUnder.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class AliTradeFundBillUnder implements Serializable {

    private static final long serialVersionUID = -6810864249129167027L;
    /**
     * 该支付工具类型所使用的金额
     */
    private String amount;

    /**
     * 银行卡支付时的银行代码
     */
    @JSONField(name = "bank_code")
    private String bankCode;

    /**
     * 交易使用的资金渠道
     */
    @JSONField(name = "fund_channel")
    private String fundChannel;

    /**
     * 渠道所使用的资金类型
     */
    @JSONField(name = "fund_type")
    private String fundType;

    /**
     * 渠道实际付款金额（单位：元)
     */
    @JSONField(name = "real_amount")
    private String realAmount;
}