package com.fshows.easypay.sdk.enums;

import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.request.merchant.MerchantAuditQueryRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantIncomeRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantInfoQueryRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantInfoSupRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantRateUpdateRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantSettleUpdateRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantSignApplyRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantUpdateRequest;
import com.fshows.easypay.sdk.request.merchant.WechatAppIdConfigRequest;
import com.fshows.easypay.sdk.request.merchant.WechatConfigQueryRequest;
import com.fshows.easypay.sdk.request.merchant.WechatJsApiConfigRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantAuditQueryResponse;
import com.fshows.easypay.sdk.response.merchant.MerchantIncomeResponse;
import com.fshows.easypay.sdk.response.merchant.MerchantInfoQueryResponse;
import com.fshows.easypay.sdk.response.merchant.MerchantInfoSupResponse;
import com.fshows.easypay.sdk.response.merchant.MerchantRateUpdateResponse;
import com.fshows.easypay.sdk.response.merchant.MerchantSettleUpdateResponse;
import com.fshows.easypay.sdk.response.merchant.MerchantSignApplyResponse;
import com.fshows.easypay.sdk.response.merchant.MerchantUpdateResponse;
import com.fshows.easypay.sdk.response.merchant.WechatAppIdConfigResponse;
import com.fshows.easypay.sdk.response.merchant.WechatConfigQueryResponse;
import com.fshows.easypay.sdk.response.merchant.WechatJsApiConfigResponse;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhaoxumin
 * @version EasyPayBaseClient.java, v 0.1 2023-10-27 13:38
 */
@Getter
public enum EasyMerchantApiEnum implements EasyPayApiDefinition {
    MERCHANT_INCOME(
            "商户信息录入",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantIncomeRequest.class,
            MerchantIncomeResponse.class
    ),
    MERCHANT_UPDATE_SUB(
            "商户信息补件",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantInfoSupRequest.class,
            MerchantInfoSupResponse.class
    ),
    MERCHANT_UPDATE(
            "商户信息修改",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantUpdateRequest.class,
            MerchantUpdateResponse.class
    ),
    MERCHANT_SETTLE_UPDATE(
            "结算账户信息修改",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantSettleUpdateRequest.class,
            MerchantSettleUpdateResponse.class
    ),
    MERCHANT_INFO_QUERY(
            "商户信息查询",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantInfoQueryRequest.class,
            MerchantInfoQueryResponse.class
    ),
    MERCHANT_AUDIT_QUERY(
            "商户审核信息查询",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantAuditQueryRequest.class,
            MerchantAuditQueryResponse.class
    ),
    MERCHANT_RATE_UPDATE(
            "商户费率修改",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantRateUpdateRequest.class,
            MerchantRateUpdateResponse.class
    ),
    MERCHANT_SIGN_APPLY(
            "商户签约申请",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantSignApplyRequest.class,
            MerchantSignApplyResponse.class
    ),
    WECHAT_APPID_CONFIG(
            "微信APPID配置",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            WechatAppIdConfigRequest.class,
            WechatAppIdConfigResponse.class
    ),
    WECHAT_DIRECT_CONFIG(
            "微信授权目录配置",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            WechatJsApiConfigRequest.class,
            WechatJsApiConfigResponse.class
    ),
    WECHAT_CONFIG_QUERY(
            "微信配置查询",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            WechatConfigQueryRequest.class,
            WechatConfigQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private final String name;
    /**
     * 接口
     */
    private final String value;
    /**
     * 请求参数类型
     */
    private final Class requestClass;
    /**
     * 响应参数类型
     */
    private final Class responseClass;

    EasyMerchantApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static EasyMerchantApiEnum getByValue(String value) {
        EasyMerchantApiEnum[] valueList = EasyMerchantApiEnum.values();
        for (EasyMerchantApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getMethod(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    public static void main(String[] args) {
        System.out.println(1);
    }
}