/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.easypay.sdk.base.SignFiled;
import com.fshows.easypay.sdk.enums.SignTypeEnum;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.util.StreamUtil;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    private static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins != null && !StringUtils.isEmpty((CharSequence)algorithm)) {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = StreamUtil.readText(ins).getBytes();
            encodedKey = Base64.getDecoder().decode(encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        return null;
    }

    private static String getContent(Map<String, String> param) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(param.keySet());
        Collections.sort(keys);
        int index = 0;
        for (String key : keys) {
            String value = param.get(key);
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            content.append(index == 0 ? "" : "&").append(key).append("=").append(value);
            ++index;
        }
        return content.toString();
    }

    private static String getVerifiedContent(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key) == null ? "" : params.get(key).toString();
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.getDecoder().decode(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static String sign(Map<String, String> data, String signType, String privateKey) {
        try {
            PrivateKey priKey = SignUtil.getPrivateKeyFromPKCS8(signType, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            String content = SignUtil.getContent(data);
            signature.update(content.getBytes("utf-8"));
            byte[] signed = signature.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String sign(String content, String signType, String privateKey) {
        try {
            PrivateKey priKey = SignUtil.getPrivateKeyFromPKCS8(signType, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes("utf-8"));
            byte[] signed = signature.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean verifySign(Map<String, Object> dataMap, String signType, String sign, String publicKey) {
        try {
            Sign signer = new Sign(SignTypeEnum.getByValue(signType).getAlgorithm(), null, SecureUtil.decode((String)publicKey));
            TreeMap sortedMap = dataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, TreeMap::new));
            String waitSignStr = SignUtil.getWaitSignStr(sortedMap);
            return signer.verify(waitSignStr.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(sign));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T> TreeMap<String, String> getParameterMap(T t) throws EasyPayException {
        Field[] fieldList = t.getClass().getDeclaredFields();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        for (Field field : fieldList) {
            String fieldName = field.getName();
            if ("serialVersionUID".equalsIgnoreCase(fieldName)) continue;
            field.setAccessible(true);
            try {
                Object o = field.get(t);
                if (o == null) continue;
                paramMap.put(fieldName, JSONObject.toJSONString((Object)o));
            }
            catch (IllegalAccessException e) {
                throw new EasyPayException("");
            }
        }
        return paramMap;
    }

    public static <T> TreeMap<String, String> getNoSignParameterMap(T t) throws EasyPayException {
        Field[] fieldList = t.getClass().getDeclaredFields();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        for (Field field : fieldList) {
            SignFiled signFiledAnnotation;
            String fieldName = field.getName();
            if ("serialVersionUID".equalsIgnoreCase(fieldName) || (signFiledAnnotation = field.getAnnotation(SignFiled.class)) == null || signFiledAnnotation.needJoin()) continue;
            field.setAccessible(true);
            try {
                Object o = field.get(t);
                if (o == null) continue;
                paramMap.put(fieldName, JSON.toJSONString((Object)o));
            }
            catch (IllegalAccessException e) {
                throw new EasyPayException("");
            }
        }
        return paramMap;
    }

    public static <T> TreeMap<String, String> getSignParameterMap(T t) throws EasyPayException {
        Field[] fieldList = t.getClass().getDeclaredFields();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        for (Field field : fieldList) {
            SignFiled signFiledAnnotation;
            String fieldName = field.getName();
            if ("serialVersionUID".equalsIgnoreCase(fieldName) || (signFiledAnnotation = field.getAnnotation(SignFiled.class)) != null && !signFiledAnnotation.needJoin()) continue;
            field.setAccessible(true);
            try {
                Object o = field.get(t);
                if (o == null) continue;
                paramMap.put(fieldName, o.toString());
            }
            catch (IllegalAccessException e) {
                throw new EasyPayException("");
            }
        }
        return paramMap;
    }

    public static TreeMap<String, String> getParameterMap(JSONObject jsonObject) {
        Map map = jsonObject.getInnerMap();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            paramMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return paramMap;
    }

    public static String generateSign(TreeMap<String, String> params, String signType, String fubeiPrivateKey) {
        List paramKeyBySort = params.keySet().stream().sorted().collect(Collectors.toList());
        Map<String, String> resultMap = SignUtil.mapKey(params);
        StringBuilder paramStrBuilder = new StringBuilder();
        for (String paramKey : paramKeyBySort) {
            if (!StrUtil.isNotBlank((CharSequence)resultMap.get(paramKey))) continue;
            paramStrBuilder.append(paramKey).append("=").append(resultMap.get(paramKey)).append("&");
        }
        String paramStr = StrUtil.removeSuffix((CharSequence)paramStrBuilder, (CharSequence)"&");
        Sign signer = new Sign(signType, SecureUtil.decode((String)fubeiPrivateKey), null);
        byte[] signed = signer.sign(paramStr.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.getEncoder().encode(signed));
    }

    public static String generateMd5Sign(TreeMap<String, String> params, String key) {
        List paramKeyBySort = params.keySet().stream().sorted().collect(Collectors.toList());
        Map<String, String> resultMap = SignUtil.mapKey(params);
        StringBuilder paramStr = new StringBuilder();
        for (String paramKey : paramKeyBySort) {
            paramStr.append(paramKey).append("=").append(resultMap.get(paramKey)).append("&");
        }
        paramStr.append("key=").append(key);
        log.info("easypay \u5f85\u52a0\u7b7e\u5b57\u7b26\u4e32: {}", (Object)paramStr);
        return SecureUtil.md5((String)paramStr.toString()).toUpperCase();
    }

    private static Map<String, String> mapKey(Map<String, String> formParam) {
        HashMap resultMap = Maps.newHashMap();
        for (String key : formParam.keySet()) {
            resultMap.put(key, formParam.get(key));
        }
        return resultMap;
    }

    public static String getWaitSignStr(Map<String, Object> dataMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || StrUtil.isBlank((CharSequence)value.toString())) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value.toString().trim());
        }
        return sb.toString();
    }
}

